 ; Ŀ
 ;   Raja - suck text into underlying attributes.  Multiple block version. 
 ;   Copyright 1994, 1995, 2005, 2007, 2009 by Rocket Software Ltd.        
 ;   Debugging is hardest when the program is doing exactly what you       
 ;   wanted and not what you think it is.                                  
 ;   Please read that again - you didn't understand it.                    
 ; 

 ; Ŀ
 ;   Clenuf - find the attribute in a list whose insertion point is        
 ;   closest to that of a text entity.                                     
 ;   Arguments: Pa, the entity midpoint.                                   
 ;              Plist, the list of attribute midpoints and enames.         
 ;   Returns an attribute ename and the list minus that sublist.           
 ; 
 (DEFUN CLENUF (pa plist / num sub distc mindis minlis gnulis)
  (setq num 0)
  (while (setq sub (nth num plist))
         (setq num (1+ num))
         (setq distc (distance pa (car sub)))
 ; Ŀ
 ;   If this is the first cycle, save the sublist and the distance.        
 ; 
         (cond ((null mindis)
                (setq mindis distc)
                (setq minlis sub))
 ; Ŀ
 ;   An amusing section: If the current distance is less than the saved    
 ;   least distance then add the saved data list to gnulis and save the    
 ;   current data list instead.                                            
 ; 
               ((< distc mindis)
                (setq mindis distc)
                (setq gnulis (append gnulis (list minlis)))
                (setq minlis sub))
 ; Ŀ
 ;   Otherwise just move the sublist to the new list.                      
 ; 
               (t
                (setq gnulis (append gnulis (list sub))))))
 (list (cadr minlis) gnulis))
 ; Ŀ
 ;   Clenuf end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Raja - suck text into blocks.                              
 ;   Arguments: Malist, the list of ((attribute_insertion  ename) ...)     
 ;              Ss, the selection set of text and attdefs.                 
 ;   Calls Spit and Clenuf.                                                
 ;   Returns nothing.                                                      
 ; 
 (DEFUN RAJA (malist ss / num enam entt str pa atnam insnam blist)
 ; Ŀ
 ;   Step through the text selection set.                                  
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
 ; Ŀ
 ;   Get the string, find the insertion point, erase the text entity.      
 ;   These are possibly exploded blocks, so there may be loose attdefs     
 ;   lying in the rubble.  For these use the tag as the string, because    
 ;   if they are being used as text that is what will be displayed, and    
 ;   if not the user is insane and it doesn't matter.                      
 ; 
         (if (= (cdr (assoc 0 entt)) "TEXT")
             (setq str (cdr (assoc 1 entt)))  ; text string
             (setq str (cdr (assoc 2 entt)))) ; attribute tag - looks like text
         (setq pa (spit entt))
         (entdel enam)
 ; Ŀ
 ;   Find the attribute whose insertion point is closest to the insertion  
 ;   point of the text.                                                    
 ; 
         (setq atnam (clenuf pa malist))
         (setq malist (cadr atnam))
         (setq atnam (car atnam))
         (setq entt (entget atnam))
         (entmod (subst (cons 1 str) (assoc 1 entt) entt))
 ; Ŀ
 ;   Save the name of the insert to a list if it isn't already a member.   
 ; 
         (setq insnam (cdr (assoc 330 entt)))
         (if (not (member insnam blist))
             (setq blist (cons insnam blist))))
 ; Ŀ
 ;   Update the blocks which were changed.                                 
 ; 
  (setq num 0)
  (while (setq enam (nth num blist))
         (setq num (1+ num))
         (entupd enam))
 (princ))
 ; Ŀ
 ;   Subroutine Raja end.                                                  
 ; 

 ; Ŀ
 ;   Reba - make a block into a list: ((inspoint attribute_ename) ...).    
 ;   Arguments: Enam, a block insertion ename.                             
 ;   Returns a list.                                                       
 ; 
 (DEFUN REBA (enam / entt pa malist)
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
         (setq pa (spit (entget enam)))
         (setq malist (cons (list pa enam) malist)))
 malist)
 ; Ŀ
 ;   Reba end.                                                             
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "ATTDEF")
      (setq yjust (cdr (assoc 74 entt)))
      (setq yjust (cdr (assoc 73 entt))))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Raja.                                                                 
 ; 
 (DEFUN C:RAJA (/ kilist ss num ssins sskill enam typ sub malist entt)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Make the list of text strings to erase and not suck into the block -  
 ;   headers and stuff that the new block will contain.                    
 ;   You are supposed to edit it.                                          
 ; 
  (setq kilist (list "AFFIXED ABOVE SHALL APPLY ONLY TO REV(s)"
                     "APPD." "AREA NAME:" "BY" "CHKD." "CLASS:" "CONT. DWG #"
                     "CONT. PROJ #" "DATE" "DRAWING #" "ENG"
                     "ENGINEER'S STAMP" "EPCM Co."
                     "EPCM No." "FACILITY:" "ISSUE STAGE" "LOCATION:" "NO."
                     "PERMIT STAMP" "PERMIT STAMP AND PROFESSIONAL STAMP"
                     "PREPARED BY:" "REFERENCE DRAWINGS" "REV"
                     "REVISION PROJECT DESCRIPTION" "SCALE:" "TCM PROJ #:"
                     "TCM PROJ:" "TCM PROJECT" "TCM. DRAWING NUMBER"
                     "UNIT NAME:"))
 ; Ŀ
 ;   Get a selection set.                                                  
 ; 
  (prompt "\nSelect text, blocks to suck it into, and trash to delete: ")
  (setq ss (ssget))
 ; Ŀ
 ;   Split it into two lists, one for blocks and one for text and attdefs. 
 ;   Erase everything which isn't either.                                  
 ; 
  (setq num 0)
  (setq ssins (ssadd))
  (setq sskill (ssadd))
  (while (setq enam (ssname ss num))
         (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
         (cond ((= typ "INSERT")
                (if (assoc 66 entt)
                    (progn
                         (ssadd enam ssins)
                         (ssdel enam ss))
                    (ssdel enam ss)))         ; don't process or erase
               ((not (member typ '("TEXT" "ATTDEF")))
                (ssadd enam sskill)
                (ssdel enam ss))
               ((and (= typ "TEXT")
                     (member (cdr (assoc 1 entt)) kilist))
                (ssadd enam sskill)
                (ssdel enam ss))
               ((and (= typ "ATTDEF")
                     (member (cdr (assoc 2 entt)) kilist))
                (ssadd enam sskill)
                (ssdel enam ss))
               (t
                (setq num (1+ num)))))
 ; Ŀ
 ;   Reduce the block ss to a list: ((insertion attribute_ename) ... ).    
 ; 
  (setq num 0)
  (if ssins
      (while (setq enam (ssname ssins num))
             (setq num (1+ num))
             (setq sub (reba enam))
             (setq malist (append malist sub)))
      (prompt "\n* No destination blocks found. *"))
 ; Ŀ
 ;   If there were text entities and blocks with attributes, suck the      
 ;   former into the latter.  Also delete trash entities.                  
 ; 
  (if (and malist ss (null (zerop (sslength ss))))
      (progn
           (if sskill (command ".erase" sskill ""))
           (raja malist ss))
      (prompt "\nInadequate selection set - not all needed entity types."))
 (princ))